using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectAddress
	/// </summary>
	public class DlgSelectAddress : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpAddress;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.ListView lvAddress;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.CheckBox cbNewAddress;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.Label lblAddresses;
		private System.ComponentModel.IContainer components = null;
		
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="addresses"></param>
		public DlgSelectAddress(DataTable addresses)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			LoadAddresses(addresses);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectAddress));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpAddress = new System.Windows.Forms.GroupBox();
			this.lblAddresses = new System.Windows.Forms.Label();
			this.cbNewAddress = new System.Windows.Forms.CheckBox();
			this.lvAddress = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage.SuspendLayout();
			this.grpAddress.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(556, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Select Address";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 226);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(8, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 176);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpAddress
			// 
			this.grpAddress.AccessibleDescription = "Select Address";
			this.grpAddress.AccessibleName = "Select Address";
			this.grpAddress.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAddress.Controls.Add(this.lblAddresses);
			this.grpAddress.Controls.Add(this.cbNewAddress);
			this.grpAddress.Controls.Add(this.lvAddress);
			this.grpAddress.Location = new System.Drawing.Point(64, 36);
			this.grpAddress.Name = "grpAddress";
			this.grpAddress.Size = new System.Drawing.Size(488, 176);
			this.grpAddress.TabIndex = 0;
			this.grpAddress.TabStop = false;
			// 
			// lblAddresses
			// 
			this.lblAddresses.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblAddresses.Location = new System.Drawing.Point(8, 12);
			this.lblAddresses.Name = "lblAddresses";
			this.lblAddresses.Size = new System.Drawing.Size(468, 20);
			this.lblAddresses.TabIndex = 0;
			this.lblAddresses.Text = "Address(es) entered previously for the manufacturer";
			this.lblAddresses.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbNewAddress
			// 
			this.cbNewAddress.AccessibleDescription = "Enter New Address";
			this.cbNewAddress.AccessibleName = "Enter New Address";
			this.cbNewAddress.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbNewAddress.Location = new System.Drawing.Point(8, 152);
			this.cbNewAddress.Name = "cbNewAddress";
			this.cbNewAddress.Size = new System.Drawing.Size(472, 20);
			this.cbNewAddress.TabIndex = 2;
			this.cbNewAddress.Text = "&Enter new address";
			this.cbNewAddress.CheckedChanged += new System.EventHandler(this.cbNewAddress_CheckedChanged);
			// 
			// lvAddress
			// 
			this.lvAddress.AccessibleDescription = "Addresses entered previously for the manufacturer";
			this.lvAddress.AccessibleName = "Addresses entered previously for the manufacturer";
			this.lvAddress.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAddress.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this.columnHeader1,
																						this.columnHeader2,
																						this.columnHeader3,
																						this.columnHeader4,
																						this.columnHeader5,
																						this.columnHeader6});
			this.lvAddress.FullRowSelect = true;
			this.lvAddress.HideSelection = false;
			this.lvAddress.Location = new System.Drawing.Point(8, 32);
			this.lvAddress.MultiSelect = false;
			this.lvAddress.Name = "lvAddress";
			this.lvAddress.Size = new System.Drawing.Size(472, 120);
			this.lvAddress.TabIndex = 1;
			this.lvAddress.View = System.Windows.Forms.View.Details;
			this.lvAddress.DoubleClick += new System.EventHandler(this.lvAddress_DoubleClick);
			this.lvAddress.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvAddress_ColumnClick);
			this.lvAddress.SelectedIndexChanged += new System.EventHandler(this.lvAddress_SelectedIndexChanged);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Address Line 1";
			this.columnHeader1.Width = 100;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Address Line 2";
			this.columnHeader2.Width = 100;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "City";
			this.columnHeader3.Width = 100;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "State";
			this.columnHeader4.Width = 40;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Zip Code";
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Phone No.";
			this.columnHeader6.Width = 65;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(396, 216);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(476, 216);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			// 
			// DlgSelectAddress
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(556, 242);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpAddress);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Maintain_Equipment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(450, 250);
			this.Name = "DlgSelectAddress";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Address";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectAddress_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpAddress, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.grpImage.ResumeLayout(false);
			this.grpAddress.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		

		/// <summary>
		/// Get Address
		/// </summary>
		public BOL.Address Address
		{
			get
			{
				if ((this.lvAddress.SelectedItems.Count>0)&&(this.lvAddress.SelectedItems[0].Tag != null))
				{
					return (BOL.Address)this.lvAddress.SelectedItems[0].Tag;
				}
				return null;
			}
		}

		/// <summary>
		/// Get PhoneNumber
		/// </summary>
		public string PhoneNumber
		{
			get
			{
				if ((this.lvAddress.SelectedItems.Count>0)&&(this.lvAddress.SelectedItems[0].Tag != null))
				{
					return this.lvAddress.SelectedItems[0].SubItems[5].Text;
				}
				return null;
			}
		}

		/// <summary>
		/// Get NewAddress
		/// </summary>
		public bool NewAddress
		{
			get
			{
				return this.cbNewAddress.Checked;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC022.DlgSelectAddress());
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(this.lvAddress, Common.StrRes.Tooltips.UC022.AddressList());
			this.SetThisToolTip(this.cbNewAddress, Common.StrRes.Tooltips.UC022.EnterNewAddress());
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
		}

		private void LoadAddresses(DataTable addresses)
		{
			this.lvAddress.Items.Clear();
			//
			foreach(DataRow drAddress in addresses.Rows)
			{
				BOL.Address address = new BOL.Address(drAddress);
				//
				//Don't add blank addresses to the list...
				if ((address.AddressLine1.Trim().Length>0)||
					(address.AddressLine2.Trim().Length>0)||
					(address.City.Trim().Length>0)||
					(address.StateCode.Trim().Length>0)||
					(address.ZipCode.Trim().Length>0)||
					(drAddress[Common.VbecsTables.Equipment.ManufacturerPhoneNumber].ToString().Trim().Length>0))
				{
					ListViewItem lvi = new ListViewItem();
					lvi.Tag = address;
					lvi.Text = address.AddressLine1;
					lvi.SubItems.Add(address.AddressLine2);
					lvi.SubItems.Add(address.City);
					lvi.SubItems.Add(address.StateCode);
					lvi.SubItems.Add(address.ZipCode);
					lvi.SubItems.Add(drAddress[Common.VbecsTables.Equipment.ManufacturerPhoneNumber].ToString());
					this.lvAddress.Items.Add(lvi);
				}
			}
			//
			if (this.lvAddress.Items.Count==0)
			{
				ListViewItem lvi = new ListViewItem();
				lvi.Tag = null;
				lvi.Text = Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString;
				this.lvAddress.Items.Add(lvi);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvAddress);
		}

		private void lvAddress_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if ((this.lvAddress.SelectedItems.Count>0)&&(this.lvAddress.SelectedItems[0].Tag != null))
			{
				this.cbNewAddress.Checked = false;
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void lvAddress_DoubleClick(object sender, System.EventArgs e)
		{
			if ((this.lvAddress.SelectedItems.Count>0)&&(this.lvAddress.SelectedItems[0].Tag != null))
			{
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		private void lvAddress_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.String);
		}

		private void cbNewAddress_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbNewAddress.Checked)
			{
				this.lvAddress.SelectedItems.Clear();
				this.btnOK.EnabledButton = true;
			}
			else
			{
				if (this.lvAddress.SelectedItems.Count == 0)
				{
					this.btnOK.EnabledButton = false;
				}
			}
		}

		/// <summary>
		/// btnOK_MouseHover Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			// **** 508 Compliance ***
			this.btnOK.SetToolTip( GetOKButtonToolTip() );
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectAddress_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( GetOKButtonToolTip() );
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <returns></returns>
		private string GetOKButtonToolTip()
		{
			return this.btnOK.EnabledButton ? 
				Common.StrRes.Tooltips.Common.OKToContinue().ResString :
				Common.StrRes.Tooltips.UC022.SelectAddressOrNewAddress().ResString;
		}
	}
}

